import { Module, OnApplicationBootstrap } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { UsersModule } from './users/users.module';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { VehicleRegistrationModule } from './vehicle-registration/vehicle-registration.module';
import { UserAuthModule } from './auth/user/user-auth.module';
import { RolesModule } from './roles/roles.module';
import { RolesSeederModule } from './roles/seeder/roles-seeder.module';
import { RolesSeederService } from './roles/seeder/roles-seeder.service';
import { AdminsModule } from './admin/admin.module';
import { AdminAuthModule } from './auth/admin/admin-auth.module';
import { PermissionsModule } from './permissions/permissions.module';
import { RolePermissionModule } from './role-permissions/role-permissions.module';
import { AdminRoleModule } from './assig-roles-admin/admin-roles.module';
import { UserRoleModule } from './assig-roles-user/user-roles.module';
import { UserPermissionModule } from './assign-permission-user/user-permission.module';
import { AdminPermissionModule } from './assign-permission-admin/admin-permission.module';
import { ServiceModule } from './service/service.module';
import { ProgramModule } from './program/program.module';
import { ServiceDetailModule } from './service-detail/service-detail.module';
import { AdminSeederModule } from './admin/seeder/admin-seeder.module';
import { AdminSeederService } from './admin/seeder/admin-seeder.service';
import { ProgramDetailModule } from './program-detail/program-detail.module';
import { SettingsSeederService } from './settings/seeder/settings-seeder.service';
import { SettingsModule } from './settings/settings.module';
import { TransactionModule } from './transaction/transaction.module';
import { NewsModule } from './news/news.module';
import { BlogModule } from './blog/blog.module';
import { VideoModule } from './video/video.module';
import { GalleryModule } from './gallery/gallery.module';
import { ServiceDetailImageModule } from './service-detail-image/service-detail-image.module';
import { CategoryModule } from './category/category.module';
import { MailModule } from './mail/mail.module';
import { ContactUsModule } from './contact-us/contact_us.module';
import { BlogCategoryModule } from './blog_category/blog_category.module';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
    }),
    TypeOrmModule.forRoot({
      type: 'mysql',
      host: 'localhost',
      port: 3306,
      // username: 'root',
      // password: '',
      // database: 'vapedepablo_baitussalam_uk',
      // database: 'bidecsolco_baitussalam_usa',
      // username: 'sql_salam_evi_plantinart_com',
      // password: '51564e0544b278',
      // database: 'sql_salam_evi_plantinart_com',
      username: 'baitussalamuk_main',
      password: 'Newpass@2025@',
      database: 'baitussalamuk_main',
      // username: 'plantinart_salam_evi',
      // password: 'Newpass@2025@',
      // database: 'plantinart_salam_evi',
      autoLoadEntities: true,
      entities: [__dirname + '/**/*.entity{.ts,.js}'],
      synchronize: true,
    }),
    UsersModule,
    VehicleRegistrationModule,
    UserAuthModule,
    RolesModule,
    RolesSeederModule,
    AdminsModule,
    AdminAuthModule,
    PermissionsModule,
    RolePermissionModule,
    AdminRoleModule,
    UserRoleModule,
    UserPermissionModule,
    AdminPermissionModule,
    ServiceModule,
    ProgramModule,
    ServiceDetailModule,
    AdminSeederModule,
    ProgramDetailModule,
    SettingsModule,
    TransactionModule,
    NewsModule,
    BlogModule,
    VideoModule,
    GalleryModule,
    ServiceDetailImageModule,
    CategoryModule,
    MailModule,
    ContactUsModule,
    BlogCategoryModule,
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule implements OnApplicationBootstrap {
  constructor(
    private readonly rolesSeederService: RolesSeederService,
    private readonly adminSeederService: AdminSeederService,
    private readonly settingsSeeder: SettingsSeederService,
  ) {}

  async onApplicationBootstrap() {
    await this.rolesSeederService.seed();
    await this.adminSeederService.seed();
    await this.settingsSeeder.seed();
  }
}
