import { IsNotEmpty, IsOptional, IsString, IsNumber } from 'class-validator';

export class CreateBlogDto {
  @IsNotEmpty()
  @IsString()
  title: string;

  @IsNotEmpty()
  @IsString()
  slug: string;

  @IsNotEmpty()
  @IsString()
  content: string;

  @IsOptional()
  @IsString()
  image?: string;

  @IsOptional()
  @IsString()
  alter_image?: string;

  // ✅ Optional category ID
  @IsOptional()
  category_id?: number;
}
