import { Injectable, NotFoundException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Category } from 'src/category/category.entity';
import { CreateCategoryDto } from 'src/category/dto/create-category.dto';
import { UpdateCategoryDto } from 'src/category/dto/update-category.dto';
import { Repository } from 'typeorm';
import { BlogCategory } from './entity/blog_category.entity';

@Injectable()
export class BlogCategoryService {
  constructor(
    @InjectRepository(BlogCategory)
    private blogCategoryRepo: Repository<BlogCategory>,
  ) {}

  async create(dto: CreateCategoryDto) {
    const category = this.blogCategoryRepo.create(dto);
    return await this.blogCategoryRepo.save(category);
  }

  async findAll() {
    return await this.blogCategoryRepo.find({ order: { id: 'DESC' } });
  }

  async findOne(id: number) {
    const category = await this.blogCategoryRepo.findOne({ where: { id } });
    if (!category) throw new NotFoundException('Category not found');
    return category;
  }

  async update(id: number, dto: UpdateCategoryDto) {
    const category = await this.findOne(id);
    Object.assign(category, dto);
    return await this.blogCategoryRepo.save(category);
  }

  async remove(id: number) {
    const category = await this.findOne(id);
    return await this.blogCategoryRepo.remove(category);
  }
}
