import { Controller, Get, Post, Put, Param, Body, UseGuards, Request } from '@nestjs/common';
import { CategoryService } from './category.service';
import { CreateCategoryDto } from './dto/create-category.dto';
import { UpdateCategoryDto } from './dto/update-category.dto';
import { AdminJwtAuthGuard } from 'src/auth/admin/admin-jwt.guard';

@Controller('categories')
export class CategoryController {
    constructor(private readonly categoryService: CategoryService) { }

    @Post('create')
    @UseGuards(AdminJwtAuthGuard)
    create(@Body() dto: CreateCategoryDto, @Request() req: any) {
        const admin = req.user as any;
        const createdBy = admin?.id;
        return this.categoryService.create(dto, createdBy);
    }

    @Get('list')
    findAll() {
        return this.categoryService.findAll();
    }

    @Get('findBy/:id')
    findBy(@Param('id') id: number) {
        return this.categoryService.findById(id);
    }

    @Put('updateBy/:id')
    @UseGuards(AdminJwtAuthGuard)
    update(@Param('id') id: number, @Body() dto: UpdateCategoryDto, @Request() req: any) {
        const admin = req.user as any;
        const updatedBy = admin?.id;
        return this.categoryService.update(id, dto, updatedBy);
    }

    @Put('toggleStatus/:id')
    @UseGuards(AdminJwtAuthGuard)
    toggleStatus(@Param('id') id: number) {
        return this.categoryService.toggleStatus(id);
    }

    @Put('softDelete/:id')
    @UseGuards(AdminJwtAuthGuard)
    softDelete(@Param('id') id: number) {
        return this.categoryService.softDelete(id);
    }
}
