import { Transaction } from 'src/transaction/transaction.entity';
import { Entity, PrimaryGeneratedColumn, Column, BeforeInsert, BeforeUpdate, OneToMany } from 'typeorm';

@Entity('categories')
export class Category {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ type: 'text' })
    name: string;

    @Column({ type: 'int', default: 1, comment: '1=active, 0=inactive, 2=softdelete' })
    status: number;

    @Column({ type: 'int', nullable: true })
    created_by: number;

    @Column({ type: 'int', nullable: true })
    updated_by: number;

    @Column({ type: 'date', nullable: true })
    created_at: string;

    @Column({ type: 'date', nullable: true })
    updated_at: string;

    @OneToMany(() => Transaction, (transaction) => transaction.category)
    transactions: Transaction[];

    @BeforeInsert()
    setDates() {
        const today = new Date().toISOString().slice(0, 10);
        this.created_at = today;
    }

    @BeforeUpdate()
    updateDate() {
        this.updated_at = new Date().toISOString().slice(0, 10);
    }
}
