import { Body, Controller, Post, UsePipes, ValidationPipe } from '@nestjs/common';
import { ContactUsService } from './contact_us.service';
import { CreateContactUsDto } from './dtos/create-contact-us.dto';

@Controller('contact-us')
export class ContactUsController {
  constructor(private readonly contactUsService: ContactUsService) {}

  @Post()
  @UsePipes(new ValidationPipe({ whitelist: true, transform: true }))
  async create(@Body() body: CreateContactUsDto) {
    const result = await this.contactUsService.submitContactForm(body);
    return result;
  }
}
