import {
    Entity,
    PrimaryGeneratedColumn,
    Column,
    BeforeInsert,
    BeforeUpdate,
} from 'typeorm';

@Entity('news')
export class News {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ type: 'varchar', unique: true })
    title: string;

    @Column({ type: 'text' })
    content: string;

    @Column({ type: 'varchar', nullable: true })
    image?: string;

    @Column({ type: 'varchar', nullable: true })
    alter_image?: string;

    @Column({ type: 'varchar' })
    author: string;

    @Column({ type: 'tinyint', default: 1 })
    status: number;

    @Column({ type: 'date', nullable: true })
    created_at: string;

    @Column({ type: 'date', nullable: true })
    updated_at: string;

    @Column({ nullable: true })
    created_by: number;

    @Column({ nullable: true })
    updated_by: number;

    @BeforeInsert()
    setCreatedAt() {
        const today = new Date().toISOString().split('T')[0];
        this.created_at = today;
    }

    @BeforeUpdate()
    setUpdatedAt() {
        this.updated_at = new Date().toISOString().split('T')[0];
    }
}
