import { Type } from 'class-transformer';
import { IsNotEmpty, IsOptional, IsNumber } from 'class-validator';

export class CreateProgramDetailDto {
    @IsNotEmpty()
    @IsNumber()
    @Type(() => Number)
    program_id: number;

    @IsNotEmpty()
    title: string;

    @IsNotEmpty()
    description: string;

    @IsOptional()
    image?: string;

    @IsOptional()
    alter_image?: string;

    @IsOptional()
    image_name?: string;
}
