import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  BeforeInsert,
  BeforeUpdate,
  OneToMany,
} from 'typeorm';
import { Service } from 'src/service/service.entity';
import { ServiceDetailImage } from 'src/service-detail-image/service-detail-image.entity';
import { ServiceBullet } from 'src/service-detail-point/service-detail-point.entity';

@Entity('service_details')
export class ServiceDetail {
  @PrimaryGeneratedColumn()
  id: number;

  @ManyToOne(() => Service, (service) => service.details, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'service_id' })
  service: Service;

  @OneToMany(() => ServiceDetailImage, (image) => image.detail, {
    cascade: true,
  })
  images: ServiceDetailImage[];

  @OneToMany(() => ServiceBullet, (bullet) => bullet.service_detail, {
    cascade: true,
  })
  bullets: ServiceBullet[];

  @Column({ nullable: false })
  service_id: number;

  @Column({ type: 'text', nullable: true })
  heading: string;

  @Column({ nullable: false })
  title: string;
  
  @Column({ type: 'text', nullable: false })
  description: string;

  @Column({ type: 'text', nullable: true })
  type: string;

  @Column({ type: 'text', nullable: true })
  button_text: string;

  @Column({ type: 'text', nullable: true })
  button_Url: string;

  @Column({ type: 'tinyint', default: 1 })
  status: number;

  @Column({ nullable: true })
  created_by: number;

  @Column({ nullable: true })
  updated_by: number;

  @Column({ type: 'date', nullable: true })
  created_at: string;

  @Column({ type: 'date', nullable: true })
  updated_at: string;

  @BeforeInsert()
  setCreateDateParts() {
    const today = new Date();
    const onlyDate = today.toISOString().split('T')[0];
    this.created_at = onlyDate;
  }

  @BeforeUpdate()
  setUpdateDate() {
    const today = new Date();
    const onlyDate = today.toISOString().split('T')[0];
    this.updated_at = onlyDate;
  }
}
