import { ServiceDetail } from 'src/service-detail/service-detail.entity';
import { Transaction } from 'src/transaction/transaction.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  BeforeInsert,
  BeforeUpdate,
  OneToMany,
} from 'typeorm';

@Entity('services')
export class Service {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ nullable: true })
  heading: string;

  @Column({ nullable: false })
  title: string;

  @Column({ type: 'text' })
  description: string;

  @Column({ type: 'text', nullable: true })
  service_image_link: string;

  @Column({ nullable: true })
  banner_heading: string;

  @Column({ nullable: true })
  banner_description: string;

  // SEO Fields
  @Column({ unique: true })
  slug: string;

  @Column({ nullable: true })
  meta_title: string;

  @Column({ nullable: true, type: 'text' })
  meta_description: string;

  @Column({ nullable: true, type: 'json' })
  schema_json: Record<string, any>;

  // @Column({ type: 'longtext', nullable: true })
  // schema_json: string;

  @Column({ nullable: true })
  canonical_url: string;

  @Column({ nullable: true , type: 'text'})
  keyword: string;

  // 1 = active , 0 = inactive
  @Column({ default: 1 })
  status: number;

  @Column({ nullable: true })
  created_by: number;

  @Column({ nullable: true })
  updated_by: number;

  @Column({ type: 'date', nullable: true })
  created_at: string;

  @Column({ type: 'date', nullable: true })
  updated_at: string;

  @OneToMany(() => ServiceDetail, (detail) => detail.service, {
    cascade: true,
  })
  details: ServiceDetail[];

  @OneToMany(() => Transaction, (transaction) => transaction.service)
  transactions: Transaction[];

  @BeforeInsert()
  setCreateDateParts() {
    const today = new Date();
    const onlyDate = today.toISOString().split('T')[0];
    this.created_at = onlyDate;
  }

  @BeforeUpdate()
  setUpdateDate() {
    const today = new Date();
    const onlyDate = today.toISOString().split('T')[0];
    this.updated_at = onlyDate;
  }
}
