import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Setting } from './settings.entity';
import { UpdateSettingDto } from './dto/update-setting.dto';

@Injectable()
export class SettingsService {
    constructor(
        @InjectRepository(Setting)
        private readonly settingRepo: Repository<Setting>,
    ) { }

    async getSettings() {
        try {
            const setting = await this.settingRepo.findOneBy({});
            if (!setting) {
                return {
                    status: false,
                    message: 'Settings not found',
                    data: null,
                };
            }

            return {
                status: true,
                message: 'Settings fetched successfully',
                data: setting,
            };
        } catch (error) {
            return {
                status: false,
                message: error.message || 'Failed to fetch settings',
                data: null,
            };
        }
    }

    async updateSettings(updateDto: UpdateSettingDto, logos?: { [key: string]: Express.Multer.File }) {
        try {
            const existing = await this.settingRepo.findOneBy({});
            if (!existing) {
                return {
                    status: false,
                    message: 'Settings not found',
                    data: null,
                };
            }

            Object.assign(existing, updateDto);

            // Update uploaded logos if provided
            if (logos?.fb_logo) existing.fb_logo = logos.fb_logo.filename;
            if (logos?.instagram_logo) existing.instagram_logo = logos.instagram_logo.filename;
            if (logos?.twitter_logo) existing.twitter_logo = logos.twitter_logo.filename;
            if (logos?.whatsapp_logo) existing.whatsapp_logo = logos.whatsapp_logo.filename;
            if (logos?.website_logo) existing.website_logo = logos.website_logo.filename;

            const updated = await this.settingRepo.save(existing);

            return {
                status: true,
                message: 'Settings updated successfully',
                data: updated,
            };
        } catch (error) {
            return {
                status: false,
                message: error.message || 'Failed to update settings',
                data: null,
            };
        }
    }
}
