// src/transaction/transaction.controller.ts
import { Controller, Post, Body, Get, Query } from '@nestjs/common';
import { TransactionService } from './transaction.service';
import { CreateTransactionDto } from './dto/create-transaction.dto';

@Controller('transactions')
export class TransactionController {
  constructor(private readonly transactionService: TransactionService) { }

  @Post('create')
  async create(@Body() dto: CreateTransactionDto) {
    return this.transactionService.create(dto);
  }

  @Get('list')
  async findAll() {
    return this.transactionService.findAll();
  }

  @Get('filter')
  async findByProgramOrService(
    @Query('program_id') programId?: number,
    @Query('service_id') serviceId?: number,
  ) {
    return this.transactionService.findByProgramOrService(programId, serviceId);
  }

}
