// src/transaction/transaction.entity.ts
import { Category } from 'src/category/category.entity';
import { Program } from 'src/program/program.entity';
import { Service } from 'src/service/service.entity';
import { Entity, PrimaryGeneratedColumn, Column, BeforeInsert, ManyToOne, JoinColumn } from 'typeorm';

@Entity()
export class Transaction {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ unique: true, nullable: true })
    transaction_id?: string;

    @Column()
    status: string;

    @Column('decimal', { precision: 10, scale: 2 })
    amount: number;

    @Column()
    currency_code: string;

    @Column()
    payment_through: string;

    @Column({ unique: true })
    invoice_no: string;

    @Column({ nullable: true })
    name: string;

    @Column({ nullable: true })
    email: string;

    @Column({ nullable: true })
    address: string;

    @Column({ nullable: true })
    telephone: string;

    @Column({ nullable: true })
    support_program: number;

    @Column({ nullable: true })
    support_service: number;

    @Column({ type: 'date' })
    created_at: string;

    @ManyToOne(() => Category, { eager: true, onDelete: 'SET NULL', nullable: true })
    @JoinColumn({ name: 'category_id' })
    category: Category;

    @Column({ nullable: true })
    category_id: number;

    @ManyToOne(() => Program, (program) => program.transactions)
    @JoinColumn({ name: 'program_id' })
    program: Program;

    @ManyToOne(() => Service, (service) => service.transactions)
    @JoinColumn({ name: 'service_id' })
    service: Service;

    @BeforeInsert()
    generateInvoiceAndDate() {
        this.invoice_no = 'INV-' + Math.floor(100000 + Math.random() * 900000);

        this.created_at = new Date().toISOString().split('T')[0];
    }
}
