import { Controller, Get, Post, Put, Delete, Param, Body, ParseIntPipe } from '@nestjs/common';
import { VideoService } from './video.service';
import { CreateVideoDto } from './dto/create-video.dto';
import { UpdateVideoDto } from './dto/update-video.dto';

@Controller('videos')
export class VideoController {
    constructor(private readonly videoService: VideoService) { }

    @Post('create')
    create(@Body() dto: CreateVideoDto) {
        return this.videoService.create(dto);
    }

    @Get('list')
    findAll() {
        return this.videoService.findAll();
    }

    @Get('findby/:id')
    findOne(@Param('id', ParseIntPipe) id: number) {
        return this.videoService.findOne(id);
    }

    @Put('updateby/:id')
    update(@Param('id', ParseIntPipe) id: number, @Body() dto: UpdateVideoDto) {
        return this.videoService.update(id, dto);
    }

    @Put('toggleStatus/:id')
    toggleStatus(@Param('id', ParseIntPipe) id: number) {
        return this.videoService.toggleStatus(id);
    }
}
