import { Entity, PrimaryGeneratedColumn, Column, BeforeInsert, BeforeUpdate } from 'typeorm';

@Entity('videos')
export class Video {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ type: 'text' })
    youtube_link: string;

    @Column({ type: 'varchar', length: 50, default: 'embedded' })
    type: string;

    @Column({ type: 'tinyint', default: 1, comment: '1=Active, 0=Inactive' })
    status: number;

    @Column({ type: 'date' })
    created_at: string;

    @Column({ type: 'date' })
    updated_at: string;

    @Column({ nullable: true })
    created_by: number;

    @Column({ nullable: true })
    updated_by: number;

    @BeforeInsert()
    setCreatedDate() {
        const today = new Date().toISOString().split('T')[0];
        this.created_at = today;
        this.updated_at = today;
    }

    @BeforeUpdate()
    setUpdatedDate() {
        this.updated_at = new Date().toISOString().split('T')[0];
    }
}
